<?php
/*--------------------------------------------------------------------------------------------------
    ProductQuantity.php 2020-3-3
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */


namespace Gambio\Shop\Product\SellingUnitQuantitiy\Quantitiy\Entities;

use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\AbstractQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ModifierQuantityInterface;

/**
 * Class ProductQuantity
 */
class ProductQuantity extends AbstractQuantity implements ModifierQuantityInterface
{
    /**
     * @var ModifierIdentifierCollectionInterface
     */
    protected $linkedModifiers = [];
    /**
     * @inheritDoc
     */
    public function linkedModifiers(): ModifierIdentifierCollectionInterface
    {
        return $this->linkedModifiers;
    }
}